#include "ActionInitialization.hh"
#include "PrimaryGeneratorAction.hh"
#include "RunAction.hh"
#include "EventAction.hh"
#include "SteppingAction.hh"
#include "DetectorConstruction.hh"

ActionInitialization::ActionInitialization(DetectorConstruction* detConstruction)
 : G4VUserActionInitialization(),
   fDetectorConstruction(detConstruction)
{}

ActionInitialization::~ActionInitialization()
{}

void ActionInitialization::BuildForMaster() const
{

}

void ActionInitialization::Build() const
{
  SetUserAction(new PrimaryGeneratorAction());
  
  RunAction* runAction= new RunAction(fDetectorConstruction);
  SetUserAction(runAction);

  SetUserAction(new EventAction(runAction));
  
  SetUserAction(new SteppingAction(runAction,fDetectorConstruction));
}  

